IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD')
begin
CREATE TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD](
	[CD_CTR_GRUPO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[QT_IT] [money] NOT NULL,
	[PERC_DESC] [money] NOT NULL,
	[VLR_IT] [money] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_GRUPO] ASC,
	[CD_EMP] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_CD_CTR_GRUPO]  DEFAULT ((0)) FOR [CD_CTR_GRUPO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_QT_IT]  DEFAULT ((0)) FOR [QT_IT]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_VLR_IT]  DEFAULT ((0)) FOR [VLR_IT]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_CG_FND_VERBA_NOTA_CREDITO_GRUPO] FOREIGN KEY([CD_CTR_GRUPO])
REFERENCES [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ([CD_CTR_GRUPO])

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] CHECK CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_CG_FND_VERBA_NOTA_CREDITO_GRUPO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD] CHECK CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_EST_PROD_EST_PROD]
END